<?php

namespace Inside\Statistics\Listeners;

use Carbon\Carbon;
use Illuminate\Contracts\Queue\ShouldQueue;
use Inside\Authentication\Events\AuthenticationLoginEvent;
use Inside\Content\Models\Contents\Users;
use Inside\Statistics\Events\AnalyticLogAuthenticationEvent;
use Inside\Statistics\Events\AnalyticLogEvent;

class UserLogAnalytic implements ShouldQueue
{
    /**
     * @param AuthenticationLoginEvent $event
     * @return void
     */
    public function handle(AuthenticationLoginEvent $event): void
    {
        $user = Users::find($event->user->uuid);
        if (! $user) {
            return;
        }
        if ($event->token->authenticator != 'inside-admin' && $event->token->created_at instanceof Carbon) {
            event(new AnalyticLogAuthenticationEvent($event->token->user, $event->token->created_at));
        }
    }

    /**
     * @return string|null
     */
    public function viaQueue(): ?string
    {
        return get_low_priority_queue_name();
    }
}
