<?php

namespace Inside\Statistics\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Inside\Authentication\Models\User;
use Inside\Reaction\Events\ReactionSubscribedEvent;
use Inside\Statistics\Events\AnalyticLogEvent;

class ReactionLogAnalytic implements ShouldQueue
{
    /**
     * @param ReactionSubscribedEvent $event
     * @return void
     */
    public function handle(ReactionSubscribedEvent $event): void
    {
        $user = User::query()->find($event->reaction->user->uuid);

        event(
            new AnalyticLogEvent(
                'reaction.'.$event->reaction->type,
                $event->reaction,
                $user,
                $event->reaction->created_at
            )
        );
    }

    /**
     * @return string|null
     */
    public function viaQueue(): ?string
    {
        return get_low_priority_queue_name();
    }
}
