<?php

namespace Inside\Statistics\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Inside\Statistics\Events\AnalyticViewLogEvent;
use Inside\Statistics\Models\ContentStatistics;

class LogViewAnalytic implements ShouldQueue
{
    /**
     * @param AnalyticViewLogEvent $event
     * @return void
     */
    public function handle(AnalyticViewLogEvent $event): void
    {
        $contentType = $event->contentType;
        ContentStatistics::bind($contentType)->insert([
            'user_uuid' => $event->user->uuid,
            'content_uuid' => $event->subject->getKey(),
            'date' => $event->when,
        ]);
    }

    /**
     * @return string|null
     */
    public function viaQueue(): ?string
    {
        return get_low_priority_queue_name();
    }
}
