<?php

namespace Inside\Statistics\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Schema;
use Inside\Statistics\Events\AnalyticLogAuthenticationEvent;
use Inside\Statistics\Models\AuthenticationStatistics;

class LogAuthentication implements ShouldQueue
{
    public function handle(AnalyticLogAuthenticationEvent $event): void
    {
        if (! Schema::hasTable('inside_authentication_statistics')) {
            return;
        }

        $userUuid = $event->user->uuid;
        $loginDate = Carbon::parse($event->when)->toDateString();
        $stats = AuthenticationStatistics::where('user_uuid', $userUuid)
            ->whereDate('created_at', $loginDate);
        if ($stats->exists()) {
            $stats->increment('connections');
        } else {
            AuthenticationStatistics::insert([
                'user_uuid' => $userUuid,
                'created_at' => $loginDate,
                'connections' => 1,
            ]);
        }
    }

    /**
     * @return string|null
     */
    public function viaQueue(): ?string
    {
        return get_low_priority_queue_name();
    }
}
