<?php

namespace Inside\Statistics\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Inside\Statistics\Events\AnalyticLogEvent;
use Inside\Statistics\Facades\Stats;

class LogAnalytic implements ShouldQueue
{
    /**
     * @param AnalyticLogEvent $event
     * @return void
     */
    public function handle(AnalyticLogEvent $event): void
    {
        $item = $event->subject;
        Stats::create(
            [
                'type' => $event->type,
                'user_uuid' => $event->user->uuid,
                'statisticable_type' => get_class($item),
                'statisticable_uuid' => $item->getKey(),
                'langcode' => $item->langcode,
                'created_at' => $event->when,
            ]
        );
    }

    /**
     * @return string|null
     */
    public function viaQueue(): ?string
    {
        return get_low_priority_queue_name();
    }
}
