<?php

namespace Inside\Statistics\Listeners;

use Exception;
use Illuminate\Contracts\Queue\ShouldQueue;
use Inside\Statistics\Events\AnalyticCancelLogEvent;
use Inside\Statistics\Models\Statistic;

class CancelLogAnalytic implements ShouldQueue
{
    /**
     * @throws Exception
     */
    public function handle(AnalyticCancelLogEvent $event): void
    {
        $item = $event->subject;
        $statistic = Statistic::where(
            [ // @phpstan-ignore-line
                'type' => $event->type,
                'statisticable_type' => get_class($item),
                'statisticable_uuid' => $item->getKey(),
                'user_uuid' => $event->user->uuid,
                'langcode' => $item->langcode,
            ]
        )->first();
        if (! is_null($statistic)) {
            $statistic->delete();
        }
    }

    /**
     * @return string|null
     */
    public function viaQueue(): ?string
    {
        return get_low_priority_queue_name();
    }
}
