<?php

namespace Inside\Statistics\Http\Controllers\Statistics;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Inside\Content\Facades\ContentHelper;
use Inside\Statistics\Repositories\StatisticsBetaRepository;
use InvalidArgumentException;

class UserVisitStatsBeta
{
    public function __invoke(string $type, Request $request, StatisticsBetaRepository $statisticsRepository): JsonResponse
    {
        if (! array_key_exists($type, config('statistics.types', []))) {
            throw new InvalidArgumentException();
        }
        $query = $statisticsRepository->getUserVisitStatsQuery(
            $type,
            ContentHelper::extractFiltersInputFromRequest($request),
            $request->get('query')
        );

        return response()->json(
            $query->get()
        );
    }
}
