<?php

namespace Inside\Statistics\Http\Controllers\Statistics;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Inside\Authentication\Models\User;
use Inside\Statistics\Events\AnalyticViewLogEvent;

class ModalViewed
{
    public function __invoke(string $type, string $uuid, Request $request): JsonResponse
    {
        try {
            /** @var User $user */
            $user = Auth::user();
            $content = call_user_func(type_to_class($type).'::findOrFail', $uuid);

            event(new AnalyticViewLogEvent($content->content_type, $content, $user, now()));
        } catch (\Exception $exception) {
            return response()->json(
                ['message' => $exception->getMessage()]
            );
        }

        return response()->json(
            ['message' => 'OK']
        );
    }
}
