<?php

namespace Inside\Statistics\Http\Controllers\Statistics;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Inside\Content\Facades\ContentHelper;
use Inside\Statistics\Contracts\Statistic;

class CountContent
{
    public function __invoke(string $type, Request $request, Statistic $statistic): JsonResponse
    {
        return response()->json(
            $statistic->countContent(explode(',', $type), ContentHelper::extractFiltersInputFromRequest($request))
        );
    }
}
