<?php

namespace Inside\Statistics\Http\Controllers\Statistics;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Inside\Content\Facades\ContentHelper;
use Inside\Content\Models\Contents\Users;
use Inside\Content\Transformers\ContentTransformer;
use Inside\Statistics\Repositories\StatisticsBetaRepository;
use InvalidArgumentException;

class ContentReadersStatsBeta
{
    public function __invoke(string $type, string $uuid, Request $request, ContentTransformer $contentTransformer, StatisticsBetaRepository $statisticsRepository): JsonResponse
    {
        $content = type_to_class($type)::findOrFail($uuid);
        $query = $request->get('query');
        $filters = ContentHelper::extractFiltersInputFromRequest($request);
        $query = $statisticsRepository->getContentReadersQuery($content, $filters, $query);
        $result = ContentHelper::getResultFromQuery($query, $filters, true);
        $result->transform(function ($item) {
            if (! $item instanceof Users) {
                $item = $item->user;
            }
            $item->image = protected_file_url($item, 'image', true, 'avatar', true);
            if ($item->status === false) {
                $item->full_name = trim(__('anonymous.user.firstname').' '.__('anonymous.user.lastname'));
                $item->email = '_';
            }

            return $item;
        });

        return response()->json(
            $result
        );
    }
}
