<?php

namespace Inside\Statistics\Http\Controllers\Statistics;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Inside\Content\Facades\ContentHelper;
use Inside\Statistics\Contracts\Statistic;

class ContentReaderStats
{
    public function __invoke(string $type, string $uuid, Request $request, Statistic $statistic): JsonResponse
    {
        $content = call_user_func(type_to_class($type).'::findOrFail', $uuid);
        $query = $request->get('query');

        return response()->json(
            $statistic->getContentReaders($content, ContentHelper::extractFiltersInputFromRequest($request), $query)
        );
    }
}
