<?php

namespace Inside\Statistics\Http\Controllers\Charts;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Inside\Content\Facades\ContentHelper;
use Inside\Statistics\Contracts\Statistic;

class VisitData
{
    public function __invoke(string $type, Request $request, Statistic $statistic): JsonResponse
    {
        return response()->json(
            $statistic->getChartVisitsData($type, ContentHelper::extractFiltersInputFromRequest($request))
        );
    }
}
