<?php

namespace Inside\Statistics\Events;

use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Carbon;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Content;
use Inside\Events\Dispatchable;

class AnalyticViewLogEvent
{
    use SerializesModels;
    use Dispatchable;

    public function __construct(
        public string $contentType,
        public Content $subject,
        public User $user,
        public Carbon $when
    ) {
    }
}
