<?php

namespace Inside\Statistics\Console;

use Illuminate\Support\Carbon;
use Inside\Console\Command;
use Inside\Statistics\Jobs\ComputeAuthenticationStatistics;
use InvalidArgumentException;

class ComputeAuthenticationStatisticsCommand extends Command
{
    /**
     * @var string
     */
    protected $signature = 'inside:stats:auth
    {--from= : Calcul des statistiques depuis cette date au format Y-m-d}
    {--to= : Calcul des statistiques jusqu\'à cette date au format Y-m-d}';

    /**
     * @var string
     */
    protected $description = 'Regénération des statistiques de connexion';

    /**
     * @return void
     */
    public function handle(): void
    {
        $from = $this->option('from');
        if (is_string($from)) {
            try {
                $from = get_date($from, 'Y-m-d');
                $from->setTime(0, 0);
            } catch (InvalidArgumentException $e) {
                $from = null;
            }
        }

        $to = $this->option('to');
        if (is_string($to)) {
            try {
                $to = get_date($to, 'Y-m-d');
                $to->setTime(23, 59, 59);
            } catch (InvalidArgumentException $e) {
                $to = null;
            }
        }

        ComputeAuthenticationStatistics::dispatchNow($from, $to, $from !== null || $to !== null, $this->getOutput());
    }
}
