<?php

namespace Inside\Statistics\Console;

use Illuminate\Support\Carbon;
use Inside\Console\Command;
use Inside\Statistics\Services\AdvancedStatisticsService;

class ComputeAdvancedStatisticsCommand extends Command
{
    /**
     * @var string
     */
    protected $signature = 'inside:stats:advanced
        {--month= : Month number (1-12)}
        {--year= : Year (YYYY)}';

    /**
     * @var string
     */
    protected $description = 'Génération des statistiques avancées';

    /**
     * @return void
     */
    public function handle(): void
    {
        $month = $this->option('month');
        $year = $this->option('year');

        if (($month === null) !== ($year === null)) {
            $this->error('Both --month and --year must be provided together.');

            return;
        }

        if ($month !== null && $year !== null) {
            if (! is_numeric($month) || (int) $month < 1 || (int) $month > 12) {
                $this->error('Month must be a number between 1 and 12.');

                return;
            }

            if (! is_numeric($year) || strlen((string) $year) !== 4) {
                $this->error('Year must be a valid 4-digit year.');

                return;
            }
        }

        $advancedStatisticsService = app(AdvancedStatisticsService::class);

        if ($month !== null && $year !== null) {
            /** @var Carbon $date */
            $date = Carbon::create((int) $year, (int) $month, 1);
            if (! $date instanceof Carbon) {
                $this->error('Invalid date provided.');

                return;
            }

            $advancedStatisticsService->overridePeriod(
                $date->copy()->startOfMonth()->toDateString(),
                $date->copy()->endOfMonth()->toDateString()
            );
        }

        $advancedStatisticsService->computeAdvancedStatistics();

        $this->info('Advanced statistics generated successfully.');
    }
}
