<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Statistiques des consultations de l'utilisateur {{ $user->full_name }}</title>
</head>
<body>
@foreach(array_keys(config('statistics.types', [])) as $type)
    <div id="chart_{{$type}}" style="height: 300px;"></div>
@endforeach

<script src="{{ url('vendor/maecia/inside/stats/resources/assets/js/Chart.min.js') }}"></script>
<script src="{{ url('vendor/maecia/inside/stats/resources/assets/js/chartisan_chartjs.umd.js') }}"></script>
<script>
    @foreach(array_keys(config('statistics.types', [])) as $type)
    const {{ \Inside\Support\Str::camel('chart_'.$type) }} = new Chartisan({
        el: '#chart_{{$type}}',
        url: '{{ route('inside.statistics.chart.user.visits.data', ['type' => $type, 'userId' => $user->uuid]) }}{!!   $filters !== null ? ('?filters='.$filters) : '' !!}',
        loader: {
            color: '#ff00ff',
            size: [60, 60],
            type: 'bar',
            textColor: '#ff00ff',
            text: 'Analyse en cours...',
        },
        hooks: new ChartisanHooks()
            .colors()
            .responsive()
            .beginAtZero()
            .borderColors()
            .legend({position: 'bottom'})
            .title('Progression des visites de contenus de type ({{$type}}) pour {{ $user->full_name }}')
            .datasets([{type: 'line', fill: true}, {type: 'line', fill: false}, {type: 'line', fill: false}, {type: 'line', fill: false}]),
    });
    @endforeach
</script>
</body>
</html>
