<?php

use Faker\Factory as Faker;
use Illuminate\Database\Seeder;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Contents\News;
use Inside\Content\Models\Contents\NewsCategories;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;
use Inside\Statistics\Events\AnalyticLogEvent;
use Symfony\Component\Console\Helper\ProgressBar;

class CreateFakeContentsSeeder extends Seeder
{
    /**
     * @return void
     */
    public function run(): void
    {
        $output = $this->command;
        $output->line('Démarrage du seeder');
        $bridge = new BridgeContent();
        app('db');
        $factory = app('Illuminate\Database\Eloquent\Factory');
        $factory->load(__DIR__.'/../factories');
        $faker = Faker::create('fr_FR');

        if (NewsCategories::whereStatus(true)->count() < 1000) {
            $output->line('Création de 200 fausses catégories d\'actualité');
            $progressBar = new ProgressBar($output->getOutput(), 200);
            $progressBar->start();
            $newsCategories = factory(NewsCategories::class, 200)->make();
            foreach ($newsCategories as $category) {
                $data = array_merge(
                    $category->getAttributes(),
                    [
                        'type' => 'node',
                        'bundle' => 'news_categories',
                    ]
                );
                $bridge->contentInsert('news_categories', $data);
                $progressBar->advance();
            }
            $progressBar->finish();
            $output->line('');
            $output->line(str_repeat('-', 80));
        }

        if (NewsCategories::whereStatus(true)->count() < 3000) {
            $output->line('Création de 1000 fausses actualités');
            $progressBar = new ProgressBar($output->getOutput(), 1000);
            $progressBar->start();
            $news = factory(News::class, 1000)->make();
            foreach ($news as $item) {
                $data = array_merge(
                    $item->getAttributes(),
                    [
                        'type'   => 'node',
                        'bundle' => 'news',
                    ]
                );
                $bridge->contentInsert('news', $data);
                $progressBar->advance();
            }
            $progressBar->finish();
            $output->line('');
            $output->line(str_repeat('-', 80));
        }

        $output->line('Création de 500 faux utilisateurs');
        $progressBar = new ProgressBar($output->getOutput(), 1000);
        $progressBar->start();
        $users = factory(Users::class, 1500)->make();
        foreach ($users as $user) {
            $data = array_merge(
                $user->getAttributes(),
                [
                    'type' => 'users',
                    'bundle' => 'users',
                ]
            );
            $userUuid = $bridge->contentInsert('users', $data);
            $reactionService = new Inside\Reaction\Services\ReactionService();
            $seenPages = $faker->randomDigit;
            if ($seenPages > 0) {
                $authUser = User::find($userUuid);
                $news = News::inRandomOrder()->whereStatus(true)->take($seenPages)->get();
                foreach ($news as $item) {
                    event(
                        new AnalyticLogEvent(
                            'view',
                            $item,
                            $authUser,
                            $faker->dateTimeBetween('-1 year')->format('Y-m-d H:i:s')
                        )
                    );

                    if ($faker->boolean(60)) {
                        $reactionService->create(
                            [
                                'type' => 'like',
                                'reactionable_type' => type_to_class('news'),
                                'reactionable_uuid' => $item->uuid,
                                'user_uuid' => $userUuid,
                                'langcode' => $item->langcode,
                            ]
                        );
                    }
                    if ($faker->boolean(30)) {
                        $bridge->contentInsert(
                            'comments',
                            [
                                'bundle' => 'news',
                                'body' => $faker->realText($faker->biasedNumberBetween(30, 60)),
                                'langcode' => $item->langcode,
                                'news' => [
                                    $item->uuid,
                                ],
                                'uid' => $userUuid,
                            ]
                        );
                    }
                }
            }
            $progressBar->advance();
        }
        $progressBar->finish();
    }
}
