<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAdvancedStatisticsTables extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (! Schema::hasTable('inside_advanced_stats_months')) {
            Schema::create('inside_advanced_stats_months', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->tinyInteger('month');
                $table->smallInteger('year');
                $table->timestamp('created_at')->useCurrent();

                $table->unique(['month', 'year']);
            });
        }

        if (! Schema::hasTable('inside_advanced_stats_attendance')) {
            Schema::create('inside_advanced_stats_attendance', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->unsignedBigInteger('month_id');
                $table->integer('authenticated_nbr')->default(0);
                $table->integer('access_nbr')->default(0);
                $table->decimal('authenticated_percentage', 5, 2)->default(0);
                $table->decimal('access_percentage', 5, 2)->default(0);
                $table->integer('users_has_role_authenticated')->default(0);
                $table->timestamp('created_at')->useCurrent();
                $table->foreign('month_id')
                    ->references('id')
                    ->on('inside_advanced_stats_months')
                    ->onDelete('cascade');
            });
        }

        if (! Schema::hasTable('inside_advanced_stats_activity_by_role')) {
            Schema::create('inside_advanced_stats_activity_by_role', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->unsignedBigInteger('month_id');
                $table->string('role_name');
                $table->integer('users_nbr')->default(0);
                $table->decimal('access_percentage', 5, 2)->default(0);
                $table->timestamp('created_at')->useCurrent();

                $table->foreign('month_id')
                    ->references('id')
                    ->on('inside_advanced_stats_months')
                    ->onDelete('cascade');

                $table->unique(['month_id', 'role_name']);
            });
        }

        if (! Schema::hasTable('inside_advanced_stats_engagement')) {
            Schema::create('inside_advanced_stats_engagement', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->unsignedBigInteger('month_id');

                $table->string('class_type');
                $table->string('role_name');
                $table->integer('users_nbr')->default(0);
                $table->integer('likes')->default(0);
                $table->integer('comments')->default(0);

                $table->timestamp('created_at')->useCurrent();

                $table->foreign('month_id')
                    ->references('id')
                    ->on('inside_advanced_stats_months')
                    ->onDelete('cascade');
            });
        }

        if (! Schema::hasTable('inside_advanced_stats_top_viewed_contents')) {
            Schema::create('inside_advanced_stats_top_viewed_contents', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->unsignedBigInteger('month_id');

                $table->string('title');
                $table->string('class_type');
                $table->uuid('uuid');
                $table->string('langcode', 10);

                $table->unsignedInteger('total_views')->default(0);

                $table->timestamp('created_at')->useCurrent();

                $table->foreign('month_id')
                    ->references('id')
                    ->on('inside_advanced_stats_months')
                    ->onDelete('cascade');
            });
        }

        if (! Schema::hasTable('inside_advanced_stats_top_liked_contents')) {
            Schema::create('inside_advanced_stats_top_liked_contents', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->unsignedBigInteger('month_id');

                $table->string('title');
                $table->string('class_type');
                $table->uuid('uuid');
                $table->string('langcode', 10);

                $table->unsignedInteger('likes')->default(0);

                $table->timestamp('created_at')->useCurrent();

                $table->foreign('month_id')
                    ->references('id')
                    ->on('inside_advanced_stats_months')
                    ->onDelete('cascade');
            });
        }

        if (! Schema::hasTable('inside_advanced_stats_top_commented_contents')) {
            Schema::create('inside_advanced_stats_top_commented_contents', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->unsignedBigInteger('month_id');

                $table->string('title');
                $table->string('class_type');
                $table->uuid('uuid');
                $table->string('langcode', 10);

                $table->unsignedInteger('comments')->default(0);

                $table->timestamp('created_at')->useCurrent();

                $table->foreign('month_id')
                    ->references('id')
                    ->on('inside_advanced_stats_months')
                    ->onDelete('cascade');
            });
        }

        if (! Schema::hasTable('inside_advanced_viewed_only_by_author')) {
            Schema::create('inside_advanced_viewed_only_by_author', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->unsignedBigInteger('month_id');

                $table->string('title');
                $table->string('class_type');
                $table->uuid('uuid');
                $table->string('langcode', 10);

                $table->timestamp('created_at')->useCurrent();

                $table->foreign('month_id')
                    ->references('id')
                    ->on('inside_advanced_stats_months')
                    ->onDelete('cascade');
            });
        }

        if (! Schema::hasTable('inside_advanced_stats_top_viewed_categories')) {
            Schema::create('inside_advanced_stats_top_viewed_categories', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->unsignedBigInteger('month_id');

                $table->string('title');
                $table->string('class_type');
                $table->uuid('uuid');
                $table->string('langcode', 10);

                $table->unsignedInteger('total_views')->default(0);
                $table->unsignedInteger('unique_views')->default(0);

                $table->timestamp('created_at')->useCurrent();

                $table->foreign('month_id')
                    ->references('id')
                    ->on('inside_advanced_stats_months')
                    ->onDelete('cascade');
            });
        }

        if (! Schema::hasTable('inside_advanced_stats_general')) {
            Schema::create('inside_advanced_stats_general', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->json('data');
                $table->unsignedBigInteger('month_id');
                $table->string('langcode', 10);
                $table->timestamp('created_at')->useCurrent();

                $table->foreign('month_id')
                    ->references('id')
                    ->on('inside_advanced_stats_months')
                    ->onDelete('cascade');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('inside_advanced_stats_months');
        Schema::dropIfExists('inside_advanced_stats_attendance');
        Schema::dropIfExists('inside_advanced_stats_activity_by_role');
        Schema::dropIfExists('inside_advanced_stats_engagement');
        Schema::dropIfExists('inside_advanced_stats_top_viewed_contents');
        Schema::dropIfExists('inside_advanced_stats_top_liked_contents');
        Schema::dropIfExists('inside_advanced_stats_top_commented_contents');
        Schema::dropIfExists('inside_advanced_viewed_only_by_author');
        Schema::dropIfExists('inside_advanced_stats_top_viewed_categories');
        Schema::dropIfExists('inside_advanced_stats_general');
    }
}
