<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Schema;

class AddLastAccessFieldToUsers extends Migration
{
    public function up(): void
    {
        if (! Schema::hasTable('inside_users')) {
            return;
        }

        if (! Schema::hasColumn('inside_users', 'last_access_at')) {
            Schema::table('inside_users', function (Blueprint $table) {
                $table->datetime('last_access_at')->nullable();
            });
        }

        Artisan::call('models:rebuild');
    }
}
