<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddUserVisitsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        Schema::create(
            'user_visits',
            function (Blueprint $table) {
                $table->increments('id');
                $table->uuid('user_uuid');
                $table->string('type');
                $table->uuid('uuid');
                $table->timestamps();
                $table->unique(['user_uuid', 'type', 'uuid']);
            }
        );
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
        Schema::dropIfExists('content_visits');
    }
}
