<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Statistics\Jobs\ComputeContentStatistics;
use Inside\Statistics\Jobs\ComputeGlobalStatistics;

class RebuildStats extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        Artisan::call('queue:restart');
        ComputeContentStatistics::dispatch(null, null, true)
            ->onConnection('lts')->delay(now()->addMinutes(30)); // Wait for update to be finished
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
    }
}
