<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateGlobalStatistics extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        Schema::create(
            'global_statistics',
            function (Blueprint $table) {
                $table->increments('id');
                $table->integer('likes')->default(0);
                $table->integer('comments')->default(0);
                $table->date('date')->unique();
            }
        );
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
        Schema::drop('global_statistics');
    }
}
