<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAuthenticationStatistics extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        Schema::create(
            'authentication_statistics',
            function (Blueprint $table) {
                $table->increments('id');
                $table->string('uuid');
                $table->string('full_name');
                $table->string('email');
                $table->boolean('enabled');
                $table->text('roles');
                $table->integer('connection_count')->default(1);
                $table->dateTime('last_login_at_timestamp')->nullable();
                $table->date('date');
                $table->unique(['uuid', 'date']);
            }
        );
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
        Schema::drop('authentication_statistics');
    }
}
