<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Authentication\Models\Token;
use Inside\Content\Models\Contents\Users;
use Inside\Statistics\Events\AnalyticLogEvent;

class AuthenticationRetroactivity extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        Token::each(
            function ($token) {
                $user = Users::find($token->user->uuid);
                if ($user) {
                    event(new AnalyticLogEvent('authentication', $user, $token->user, $token->created_at));
                }
            }
        );
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
    }
}
