<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateStatisticsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        Schema::create('inside_statistics', function (Blueprint $table) {
            $table->increments('id');
            $table->string('type', 255)->nullable();
            $table->uuid('user_uuid')->collate('utf8');
            $table->uuid('statisticable_uuid')->collate('utf8');
            $table->string('statisticable_type', 255);
            $table->char('langcode', 2)->nullable();
            $table->timestamps();
            $table->index(['user_uuid', 'type']);
            $table->index('statisticable_uuid');
            $table->index('langcode');
            $table->foreign('user_uuid')
                ->references('uuid')->on('inside_users')
                ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
        Schema::dropIfExists('inside_statistics');
    }
}
