<?php

use Faker\Generator as Faker;
use Illuminate\Support\Str;

$factory->define(
    Inside\Content\Models\Contents\Users::class,
    function (Faker $faker) {
        $firstName = $faker->firstName;
        $lastName = $faker->lastName;

        $folder = cms_base_path(config('app.app_storage_path').'/chunks/'.Str::random());
        if (! File::exists($folder)) {
            File::makeDirectory($folder);
        }

        return [
            'name'           => $firstName.' '.$lastName,
            'firstname'      => $firstName,
            'lastname'       => $lastName,
            'langcode'       => $faker->randomElement(list_languages()),
            'email'          => $faker->unique()->email,
            'status'         => $faker->boolean(80),
            //    'image'          => $faker->image(cms_base_path(config('app.app_storage_path') . '/chunks')),
            'image'          => str_replace(
                cms_base_path(config('app.app_storage_path')).'/',
                '',
                $faker->file(
                    cms_base_path(config('app.app_storage_path').'/fakes'),
                    $folder
                )
            ),
            'is_maintenance' => $faker->boolean(1),
        ];
    }
);
