<?php

use Faker\Generator as Faker;
use Illuminate\Support\Str;

$factory->define(
    Inside\Content\Models\Contents\News::class,
    function (Faker $faker) {
        $author = Inside\Content\Models\Contents\Users::where('email', config('app.technical_mail'))->first();

        if (! function_exists('pickRandom')) {
            function pickRandom($type): array
            {
                $query = call_user_func(type_to_class($type).'::query');

                return $query->inRandomOrder()->pluck('uuid')->take(
                    Illuminate\Support\Arr::random(range(1, 5))
                )->unique()->all();
            }
        }
        $created_at = $faker->dateTimeBetween('-1 year')->format('Y-m-d H:i:s');

        $folder = cms_base_path(config('app.app_storage_path').'/chunks/'.Str::random());
        if (! File::exists($folder)) {
            File::makeDirectory($folder);
        }

        return [
            'title'           => $faker->sentence,
            'created_at'      => $created_at,
            'updated_at'      => $created_at,
            'langcode'        => $faker->randomElement(list_languages()),
            'status'          => $faker->boolean(80),
            'author'          => $author->uuid,
            'body'            => $faker->realText,
            'chapo'           => $faker->realText(50),
            'news_categories' => pickRandom('news_categories'),
            //   'image'          => $faker->image(cms_base_path(config('app.app_storage_path') . '/chunks')),
            'image'           => str_replace(
                cms_base_path(config('app.app_storage_path')).'/',
                '',
                $faker->file(
                    cms_base_path(config('app.app_storage_path').'/fakes'),
                    $folder
                )
            ),
        ];
    }
);
