<?php

use Faker\Generator as Faker;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Str;

$factory->define(
    Inside\Content\Models\Contents\NewsCategories::class,
    function (Faker $faker) {
        $author = Inside\Content\Models\Contents\Users::where('email', config('app.technical_mail'))->first();

        $created_at = $faker->dateTimeBetween('-1 year')->format('Y-m-d H:i:s');

        $folder = cms_base_path(config('app.app_storage_path').'/chunks/'.Str::random());
        if (! File::exists($folder)) {
            File::makeDirectory($folder);
        }

        return [
            'title' => $faker->sentence,
            'created_at' => $created_at,
            'updated_at' => $created_at,
            'langcode' => $faker->randomElement(list_languages()),
            'status' => $faker->boolean(80),
            'author' => $author->uuid,
            // 'image'          => $faker->image(cms_base_path(config('app.app_storage_path') . '/chunks')),
            'image' => str_replace(
                cms_base_path(config('app.app_storage_path')).'/',
                '',
                $faker->file(
                    cms_base_path(config('app.app_storage_path').'/fakes'),
                    $folder
                )
            ),
        ];
    }
);
