<?php

namespace Inside\Slug\Providers;

use Inside\Slug\Console\Commands\RebuildCommand;
use Inside\Slug\Contracts\ContentUrlGenerator;
use Inside\Slug\Services\ContentUrlGeneratorService;
use Inside\Slug\Services\SlugService;
use Inside\Support\EventServiceProvider;

class SlugServiceProvider extends EventServiceProvider
{
    protected array $commands = [
        RebuildCommand::class,
    ];

    public array $singletons = [
        SlugService::class => SlugService::class,
        ContentUrlGenerator::class => ContentUrlGeneratorService::class,
    ];

    public function register(): void
    {
        $this->mergeConfigFrom(__DIR__.'/../../config/slug.php', 'slug');
        $this->mergeConfigFrom(__DIR__.'/../../config/sluggable.php', 'sluggable');
    }
}
