<?php

namespace Inside\Slug\Concerns;

use Exception;
use Inside\Content\Facades\Schema;
use Inside\Slug\Models\Slug;
use Inside\Slug\Services\SlugService;

trait SlugTrait
{
    /**
     * @return void
     */
    public static function bootSlugTrait(): void
    {
        static::saving(function ($model) {
            $model->buildSlug();
        });

        static::deleting(function ($model) {
            $model->deleteSlug();
        });
    }

    /**
     * @return void
     * @throws Exception
     */
    public function buildSlug(): void
    {
        $slug = new SlugService();
        $slug->slug($this);
    }

    /**
     * @return void
     * @throws Exception
     */
    public function deleteSlug(): void
    {
        $slug = new SlugService();
        $slug->deleteSlug($this);
    }

    /**
     * @return null|array
     */
    public function getSlugAttribute(): ?array
    {
        if ($this::class::isAliasable() && $this->uuid) {
            $slugs = Slug::where('uuid', '=', $this->uuid)->get();

            return $slugs->pluck('slug')->unique()->toArray();
        }

        return null;
    }

    /**
     * @return array
     */
    abstract public function sluggable(): array;
}
