<?php

namespace Inside\Slug\Seeders;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Inside\Slug\Models\Slug;

class ChangeUniqueSlugs extends Seeder
{
    private const UNIQUE_SLUGS_CONSTRAINT = 'inside_slugs_slug_unique';

    private const SLUGS_TABLE = 'inside_slugs';

    public function run(): void
    {
        if (config('slug.unique')) {
            $this->makeUniqueSlugsConstraint();
        } else {
            $this->dropUniqueSlugsConstraint();
        }

        Artisan::call('slug:rebuild --force');
    }

    private function hasUniqueSlugsConstraint(): bool
    {
        return collect(DB::getDoctrineSchemaManager()->listTableIndexes(self::SLUGS_TABLE))->has(self::UNIQUE_SLUGS_CONSTRAINT);
    }

    private function makeUniqueSlugsConstraint(): void
    {
        if ($this->hasUniqueSlugsConstraint()) {
            return;
        }

        Slug::truncate();

        Schema::table('inside_slugs', function (Blueprint $table) {
            $table->unique('slug', self::UNIQUE_SLUGS_CONSTRAINT);
        });
    }

    private function dropUniqueSlugsConstraint(): void
    {
        if (! $this->hasUniqueSlugsConstraint()) {
            return;
        }

        Schema::table('inside_slugs', function (Blueprint $table) {
            $table->dropUnique(self::UNIQUE_SLUGS_CONSTRAINT);
        });
    }
}
