<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSlugsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('inside_slugs', function (Blueprint $table) {
            $table->increments('id');
            $table->uuid('uuid')->collate('utf8');
            $table->string('type', 255)->nullable();
            $table->char('langcode', 2)->nullable();
            $table->string('slug', 255);
            $table->index('uuid');
            $table->index('slug');
            $table->index(['slug', 'uuid', 'langcode']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('inside_slugs');
    }
}
