<?php

declare(strict_types=1);

use Illuminate\Support\Facades\Route;

Route::group(
    [
        'namespace' => 'Inside\Sharepoint\Http\Controllers',
        'prefix' => 'api/v1/sharepoint',
        'middleware' => ['auth.api'],
    ],
    function ($router) {
        $router->get('/', ['uses' => 'SharePointController@getDrives']);
        $router->get('/browse/{driveId}', ['uses' => 'SharePointController@browseDrive']);
        $router->get('/browse/{driveId}/{itemId}', ['uses' => 'SharePointController@browseDrive']);
    }
);
