<?php

namespace Inside\Sharepoint\Http\Controllers;

use Illuminate\Http\Request;
use Inside\Sharepoint\Services\SharePointService;

class SharePointController
{
    public function __construct(private SharePointService $sharePointService) {

    }

    public function getDrives()
    {
        $site = $this->sharePointService->getSite();
        $drives = $this->sharePointService->listDrives($site['id']);

        return response()->json([
            'site' => [
                'id'   => $site['id'],
                'name' => $site['displayName'],
                'url'  => $site['webUrl'],
            ],
            'drives' => $drives,
        ]);
    }

    /**
     * Racine d’un drive
     */
    public function browseDrive(string $driveId, ?string $itemId = null)
    {
        return response()->json($this->sharePointService->listItems($driveId, $itemId));
    }
}
