<?php

use Illuminate\Support\Facades\Route;

Route::group(
    [
        'namespace' => 'Inside\Settings\Http\Controllers',
        'prefix'    => 'api/v1',
    ],
    function ($router) {
        $router->get('settings[/{group}]', 'SettingController@listSettings');
    }
);

Route::group(
    [
        'namespace'  => 'Inside\Settings\Http\Controllers',
        'prefix'     => 'api/v1',
        'middleware' => [
            'auth.role:super_administrator',
        ],
    ],
    function ($router) {
        $router->put('settings', 'SettingController@storeSetting');
        $router->get('admin/settings/export', 'SettingController@exportDesigns');
        $router->post('admin/settings/import', 'SettingController@importDesigns');
        $router->get('admin/settings/audit', 'AuditController');
    }
);

Route::group(
    [
        'namespace'  => 'Inside\Settings\Http\Controllers',
        'prefix'     => 'api/v1',
        'middleware' => ['auth.api'],
    ],
    function ($router) {
        $router->get('options/{key}', 'SettingController@listOptions');
        $router->put('options', 'SettingController@storeOption');

        // Fonts
        Route::group([
            'prefix' => 'font',
        ], function ($router) {
            $router->get('google', 'GoogleFontsController');
            $router->post('import', 'ImportFontsController');
        });

        // Emails
        Route::group([
            'prefix' => 'email',
        ], function ($router) {
            $router->put('update', 'SetupEmailSettingsController');
        });
    }
);
