<?php

namespace Inside\Settings\Services;

use Illuminate\Http\UploadedFile;
use Illuminate\Support\Facades\Storage;
use Inside\Settings\Models\Setting;

class ImportFontsService
{
    public function importFont(string $type, string $font, UploadedFile $fontFile): array
    {
        $fileName = str(pathinfo($fontFile->getClientOriginalName(), PATHINFO_FILENAME))
            ->lower()
            ->limit(50, '')
            ->append('-'.$font.'-'.$type.'.'.$fontFile->getClientOriginalExtension());

        $disk = Storage::disk('assets');

        $filePath = $disk->putFileAs('system', $fontFile, $fileName);
        $filePath = 'assets/'.$filePath;

        $fontKey = sprintf('font_%s_import_%s', $font, $type);

        $this->deleteOldFileIfExists($fontKey);

        $this->updateFontSettings($font, $filePath, $fontKey);

        return [
            'file' => $filePath,
            'name' => $fileName,
            'size' => $fontFile->getSize(),
            'mime' => $fontFile->getMimeType(),
            'font' => $font,
            'type' => $type,
        ];
    }

    private function deleteOldFileIfExists(string $fontKey): void
    {
        $fileToDelete = Setting::where('key', $fontKey)->value('value');
        if (! is_null($fileToDelete) && Storage::disk()->exists($fileToDelete)) {
            Storage::disk()->delete($fileToDelete);
        }
    }

    private function updateFontSettings(string $font, string $filePath, string $fontKey): void
    {
        Setting::updateOrCreate(
            ['key' => sprintf('font_source_%s', $font), 'group' => 'general'],
            ['value' => 'import']
        );
        Setting::updateOrCreate(
            ['key' => $fontKey, 'group' => 'general'],
            ['value' => $filePath]
        );
    }
}
