<?php

namespace Inside\Settings\Services;

use Illuminate\Http\UploadedFile;
use Illuminate\Validation\ValidationException;
use Symfony\Component\Config\Resource\FileResource;

/**
 * Class FontValidatorService
 */
class FontValidatorService
{
    private const ALLOWED_SIGNATURES = [
        'ttf'  => '00 01 00 00',
        'woff' => '77 4f 46 46',
        'woff2'=> '77 4f 46 32',
        'otf'  => '4f 54 54 4f',
    ];

    /**
     * @throws ValidationException
     */
    public function validate(UploadedFile $uploadedFile): void
    {
        /**
         * @var resource $file
         */
        $file = fopen($uploadedFile->getRealPath(), 'r');
        $signature = trim(chunk_split(bin2hex(fread($file, 4)), 2, ' '));
        fclose($file);

        $extension = collect(self::ALLOWED_SIGNATURES)->search($signature);
        if ($extension === false) {
            throw ValidationException::withMessages(
                [
                    'font' => 'Invalid font file. The signature does not match allowed formats.',
                ]
            );
        }
    }
}
