<?php

namespace Inside\Settings\Services;

use Inside\Settings\Audit\Interfaces\TestInterface;

class AuditExecutor
{
    /**
     * Execute all the tests and return the results.
     *
     * @return array
     */
    public function executeTests(): array
    {
        $auditResults = [];
        $testGroups = config('audit');

        foreach ($testGroups as $groupConfig) {
            $groupClass = $groupConfig['group_class'];
            $group = new $groupClass();

            if ($group instanceof TestInterface) {
                $groupResults = $group::execute();

                $auditResults[] = [
                    'group' => $group::getLabel(),
                    'results' => $groupResults,
                ];
            }
        }

        return $auditResults;
    }
}
