<?php

namespace Inside\Settings\Observers;

use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Storage;
use Inside\Settings\Models\Setting;

class SettingObserver
{
    public function saving(Setting $setting): void
    {
        $fontsKeyToCheck = [
            'font_primary_import_bold',
            'font_primary_import_light',
            'font_primary_import_normal',
            'font_secondary_import_bold',
            'font_secondary_import_light',
            'font_secondary_import_normal',
        ];

        if (in_array($setting->key, $fontsKeyToCheck) && is_null($setting->value)) {
            $fileToDelete = Setting::where('key', $setting->key)->value('value');

            if (! is_null($fileToDelete) && Storage::disk()->exists($fileToDelete)) {
                Storage::disk()->delete($fileToDelete);
            }
        }
    }
}
