<?php

namespace Inside\Settings\Models;

use Event;
use Illuminate\Database\Eloquent\Model;
use Inside\Database\Query\Builder;
use Inside\Settings\Events\SettingSavedEvent;

/**
 * inside\Settings\Models\Setting
 *
 * @property int $id
 * @property string $key
 * @property string|null $value
 * @property string $group
 * @method static \Illuminate\Database\Eloquent\Builder|\inside\Settings\Models\Setting newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\inside\Settings\Models\Setting newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\inside\Settings\Models\Setting query()
 * @method static \Illuminate\Database\Eloquent\Builder|\inside\Settings\Models\Setting whereGroup($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\inside\Settings\Models\Setting whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\inside\Settings\Models\Setting whereKey($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\inside\Settings\Models\Setting whereValue($value)
 * @method static \Illuminate\Database\Eloquent\Builder where($column, $operator = null, $value = null, $boolean = 'and')
 * @method static static firstOrCreate(array $attributes, array $values = [])
 * @mixin Builder
 * @mixin \Illuminate\Database\Eloquent\Builder
 * @mixin \Eloquent
 * @OA\Schema (schema="inside\Settings\Models\Setting",title="setting",type="object",description="Dynamic model generated by inside content",@OA\Property(property="id",
 * title="id",
 * type="integer",
 * description=""),
 * @OA\Property(property="key",
 * title="key",
 * type="string",
 * description=""),
 * @OA\Property(property="value",
 * title="value",
 * type="string|null",
 * description=""),
 * @OA\Property(property="group",
 * title="group",
 * type="string",
 * description=""))
 */
class Setting extends Model
{
    protected $table = 'inside_settings';

    public $timestamps = false;

    protected $fillable = [
        'key',
        'value',
        'group',
    ];

    public static function boot()
    {
        parent::boot();

        self::saved(function ($model) {
            Event::dispatch(new SettingSavedEvent($model));
        });
    }
}
