<?php

namespace Inside\Settings\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Cache;
use Inside\Settings\Events\SettingSavedEvent;

class ExtensionsSavedListener implements ShouldQueue
{
    use InteractsWithQueue;

    public int $timeout = 0;

    public int $tries = 1;

    public function handle(SettingSavedEvent $event): void
    {
        set_time_limit(0);

        if ($event->model->group !== 'contentManagement' || $event->model->key === 'file_extensions') {
            return;
        }

        $cacheKey = 'extensions_saved_processing';
        if (Cache::has($cacheKey)) {
            return;
        }

        try {
            Cache::put($cacheKey, true, 900);

            Artisan::call('inside:repair:image-extensions');
            Artisan::call('inside:repair:file-extensions');
            Artisan::call('inside:repair:video-extensions');
            Artisan::call('inside:paragraph:config:generate');
            Artisan::call('inside:paragraph:config:import');
        } finally {
            Cache::forget($cacheKey);
        }
    }
}
