<?php

namespace Inside\Settings\Http\Requests;

use Illuminate\Support\Facades\Lang;
use Inside\Http\Requests\FormRequest;

class EmailSettingsStoreRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        $addressEmailRule = 'email';
        if (config('app.secured_email_validation', true)) {
            $addressEmailRule = 'emailpp:rfc,dns';
        }

        return [
            'from_name' => [
                'string',
            ],
            'from_address' => [
                $addressEmailRule,
            ],
        ];
    }

    public function messages(): array
    {
        $addressEmailRule = 'email';
        if (config('app.secured_email_validation', true)) {
            $addressEmailRule = 'emailpp:rfc,dns';
        }

        return [
            'from_name.string' => Lang::get('validation.string'),
            'from_address.'.$addressEmailRule => Lang::get('validation.email'),
        ];
    }
}
