<?php

namespace Inside\Settings\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Auth;
use Inside\Jobs\Queue\RestartQueue;
use Inside\Permission\Exceptions\AuthorizationException;
use Inside\Settings\Http\Requests\EmailSettingsStoreRequest;
use Inside\Settings\Services\SettingStore;
use Laravel\Lumen\Routing\Controller;

class SetupEmailSettingsController extends Controller
{
    public function __invoke(
        SettingStore $settingStore,
        EmailSettingsStoreRequest $request)
    : JsonResponse
    {
        // Check user authorization
        $me = Auth::user();
        if (! $me) {
            throw AuthorizationException::create('upload', 'settings');
        }

        $name = $request->get('from_name');
        $email = $request->get('from_address');

        $data = $request->validated();
        $s = collect($data)
            ->each(fn ($value, $field) => $settingStore->set('email', $field, $value));

        RestartQueue::dispatch();

        return response()->json(['sucess' => true]);
    }
}
