<?php

namespace Inside\Settings\Console;

use Inside\Console\Command;
use Inside\Settings\Services\AuditExecutor;
use Symfony\Component\Console\Helper\Table;

class AuditCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'inside:audit:run';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Run the audit tests and show the results';

    /**
     * Execute the console command.
     *
     * @param AuditExecutor $auditExecutor
     * @return void
     */
    public function handle(AuditExecutor $auditExecutor)
    {
        $this->info('Running audit tests...'.PHP_EOL);

        $testResults = $auditExecutor->executeTests();

        foreach ($testResults as $testGroup) {
            $this->info('Group: '.$testGroup['group']);

            $table = new Table($this->output);
            $table->setHeaders(['Label', 'Status', 'Symbol', 'Message']);

            $this->formatResults($table, $testGroup['results'], '');

            $table->render();
            $this->line('');
        }
    }

    private function formatResults($table, $result, $prefix = '')
    {
        $table->addRow([
            $prefix.$result['label'],
            $result['status'],
            $result['status_symbol'],
            $result['message'] ?: '-',
        ]);

        if (! empty($result['results'])) {
            foreach ($result['results'] as $childResult) {
                $this->formatResults($table, $childResult, $prefix.'  └-- ');
            }
        }
    }
}
