<?php

namespace Inside\Settings\Audit\Tests\ServerConfiguration;

use Illuminate\Support\Facades\Redis;
use Inside\Settings\Audit\Tests\BaseTest;

class RedisVersionTest extends BaseTest
{
    public static function check(): bool
    {
        try {
            $info = Redis::connection()->client()->info();
            self::setMessage(__('audit.current.version').$info['Server']['redis_version']);

            return true;
        } catch (\Exception $exception) {
            self::setMessage($exception->getMessage());

            return false;
        }
    }

    public static function getLabel(): string
    {
        return 'Redis';
    }
}
