<?php

namespace Inside\Settings\Audit\Tests\ServerConfiguration;

use Inside\Settings\Audit\Tests\BaseTest;

class MemoryLimitTest extends BaseTest
{
    public static function check(): bool
    {
        $memoryLimit = (int) ini_get('memory_limit');
        self::setMessage(__('audit.current.value').$memoryLimit);

        return $memoryLimit >= 512;
    }

    public static function getLabel(): string
    {
        return __('audit.memory_limit.value');
    }
}
