<?php

namespace Inside\Settings\Audit\Tests\ServerConfiguration;

use Inside\Settings\Audit\Tests\BaseTest;

class ExtensionsTest extends BaseTest
{
    public static function check(): bool
    {
        $requiredExtensions = [
            'libxml',
            'openssl',
            'hash',
            'json',
            'PDO',
            'xml',
            'bcmath',
            'curl',
            'dom',
            'mbstring',
            'gd',
            'intl',
            'redis',
            'zip',
        ];

        $installedExtensions = get_loaded_extensions();
        $missingExtensions = array_diff($requiredExtensions, $installedExtensions);

        if (! $missingExtensions) {
            return true;
        }

        self::setMessage(__('audit.missing_php_extensions.message').implode(',', $missingExtensions));

        return false;
    }

    public static function getLabel(): string
    {
        return __('audit.php.extensions');
    }
}
