<?php

namespace Inside\Settings\Audit\Tests\ContentTypes;

use Illuminate\Support\Str;
use Inside\Content\Facades\Schema;
use Inside\Settings\Audit\Tests\BaseTest;

class IsContentTypesTranslatableTest extends BaseTest
{
    public static function check(): bool
    {
        $newsletterTypes = array_keys(config('newsletters.types', []));

        $typesNotTranslatable = collect(Schema::getContentTypes())
            ->reject(fn ($type) => Str::endsWith($type, '_menus') ||
                in_array($type, ['comments', 'users', 'image_styles']) ||
                in_array($type, $newsletterTypes)
            )
            ->filter(fn ($type) => Schema::getSchemaInformation($type)['options']['translatable'] !== true);

        if ($typesNotTranslatable->isNotEmpty()) {
            self::setMessage(__('audit.content_types.translatable.error_message').implode(', ', $typesNotTranslatable->toArray()));

            return false;
        }

        return true;
    }

    public static function shouldIgnore(): bool
    {
        return count(list_languages()) === 1;
    }

    public static function getLabel(): string
    {
        return __('audit.content_types.translatable.title');
    }
}
