<?php

namespace Inside\Settings\Audit\Tests\ContentTypes;

use Illuminate\Support\Str;
use Inside\Content\Facades\Schema;
use Inside\Settings\Audit\Tests\BaseTest;

class GlobalSearchableContentTypesTest extends BaseTest
{
    public static function check(): bool
    {
        $excludedFields = [
            'uuid',
            'title',
            'status',
            'pid',
            'update_author',
            'langcode',
            'author',
            'created_at',
            'updated_at',
            'published_at',
        ];

        $excludedWidgetsTypes = [
            'color_picker',
            'icon_picker',
        ];

        $typesGlobalSearchable = collect(Schema::getContentTypes())
            ->reject(fn ($type) => Str::endsWith($type, '_menus') || in_array($type, ['comments', 'users']))
            ->filter(fn ($type) => Schema::getSchemaInformation($type)['options']['global_searchable'] === true);

        $unsearchableFields = [];
        foreach ($typesGlobalSearchable as $type) {
            $fields = collect(Schema::getFieldListing($type))
                ->reject(fn ($field) => in_array($field, $excludedFields))
                ->map(fn ($field) => [
                    'type' => $type,
                    'field' => $field,
                    'options' => Schema::getFieldOptions($type, $field),
                ])
                ->reject(fn ($item) => in_array($item['options']['widget_type'], $excludedWidgetsTypes))
                ->filter(fn ($item) => in_array($item['options']['type'], ['text', 'textarea']))
                ->reject(fn ($item) => isset($item['options']['searchable']) && $item['options']['searchable'] === true)
                ->values()
                ->toArray();

            $unsearchableFields = array_merge($unsearchableFields, $fields);
        }

        $unsearchableFieldMessage = collect($unsearchableFields)
            ->groupBy('type')
            ->map(fn ($items, $type) => $type.'('.$items->pluck('field')->implode(', ').')')
            ->implode(', ');

        if ($typesGlobalSearchable->isEmpty()) {
            self::setMessage(__('audit.content_types.global_searchable.error_message'));

            return false;
        }

        if (empty($unsearchableFields)) {
            self::setMessage(__('audit.content_types.global_searchable.with.fields.searchable').implode(', ', $typesGlobalSearchable->toArray()));

            return true;
        } else {
            self::setMessage(__('audit.content_types.global_searchable.with.fields.searchable.error_message').$unsearchableFieldMessage);

            return false;
        }
    }

    public static function getLabel(): string
    {
        return __('audit.content_types.global_searchable.title');
    }
}
