<?php

namespace Inside\Settings\Audit\TestGroups;

use Inside\Settings\Audit\Tests\BaseTest;
use Inside\Settings\Audit\Tests\ServerConfiguration\ApacheVersionTest;
use Inside\Settings\Audit\Tests\ServerConfiguration\ExtensionsTest;
use Inside\Settings\Audit\Tests\ServerConfiguration\MaxExecutionTimeTest;
use Inside\Settings\Audit\Tests\ServerConfiguration\MemoryLimitTest;
use Inside\Settings\Audit\Tests\ServerConfiguration\PhpVersionTest;
use Inside\Settings\Audit\Tests\ServerConfiguration\PostMaxSizeTest;
use Inside\Settings\Audit\Tests\ServerConfiguration\RedisVersionTest;

class ServerConfigurationTestGroup extends BaseTest
{
    protected static array $childTests = [
        PhpVersionTest::class,
        MaxExecutionTimeTest::class,
        MemoryLimitTest::class,
        PostMaxSizeTest::class,
        ExtensionsTest::class,
        RedisVersionTest::class,
    ];

    public static function getLabel(): string
    {
        return __('audit.server_configuration.groupe.title');
    }
}
